Hooks:PostHook(RaycastWeaponBase, "init", "sora_init_low_ammo_click_sound", function(self)
    self._low_ammo_sound_device = SoundDevice:create_source("sora_low_ammo")

    if alive(self._setup.user_unit) then
        self._low_ammo_sound_device:set_position(self._setup.user_unit:position())
    end

    self.allowed_categories = {}

    for _, category in ipairs({
        "assault_rifle",
        "snp",
        "lmg",
        "smg",
        "pistol",
        "akimbo",
        "revolver",
        "shotgun"
    }) do
        self.allowed_categories[category] = true
    end -- made allowed_categories into a set that holds each category as a key.
end)

Hooks:PostHook(RaycastWeaponBase, "fire", "sora_post_init_fire_click", function(self)
    if self._setup.user_unit ~= managers.player:player_unit() then
        return
    end -- checking if the object calling "fire" is the player.

    if not self._low_ammo_sound_device then
        self:_force_init_sound_device_fucking_conflicts()
    end

    local pass = false

    for _, category in ipairs(self:weapon_tweak_data().categories) do
        if self.allowed_categories[category] == true then
            pass = true
            break
        end
    end -- checking if the weapon's category is allowed, but, instead of comparing values with a second loop, it checks if the category is set to true in allowed_categories.

    local base = self:ammo_base()
    local current_mag = base:get_ammo_remaining_in_clip()
    local max_in_mag = base:get_ammo_max_per_clip()

    if pass then
        if math.floor(current_mag) <= math.floor(max_in_mag / 4) then -- replaced the threshold variable with 4 because it was only being used here.
            self._low_ammo_sound_device:post_event("low_ammo_click")
        end
    end
end)

function RaycastWeaponBase:_force_init_sound_device_fucking_conflicts()
    self._low_ammo_sound_device = SoundDevice:create_source("sora_low_ammo")

    if alive(self._setup.user_unit) then
        self._low_ammo_sound_device:set_position(self._setup.user_unit:position())
    end
end
